

<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.9.4/Chart.min.css">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="dashboard-container">
    <div class="dashboard-header">
        <h1>Admin Dashboard</h1>
        <p>Welcome back, <?php echo e(auth()->user()->name); ?></p>
    </div>

    <!-- Top Stats Overview -->
    <div class="dashboard-stats">
        <div class="stat-card">
            <div class="stat-card-inner">
                <h3>Total Users</h3>
                <div class="stat-value"><?php echo e(\App\Models\User::count()); ?></div>
                <div class="stat-icon">
                    <i class="fas fa-users"></i>
                </div>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-card-inner">
                <h3>Forum Threads</h3>
                <div class="stat-value"><?php echo e(\App\Models\ForumThread::count()); ?></div>
                <div class="stat-icon">
                    <i class="fas fa-comments"></i>
                </div>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-card-inner">
                <h3>Revenue (30d)</h3>
                <div class="stat-value"><?php echo e(currency_symbol(config_value('store_currency', 'GBP'))); ?><?php echo e(number_format(\App\Models\Transaction::where('status', 'completed')->where('created_at', '>=', \Carbon\Carbon::now()->subDays(30))->sum('amount'), 2)); ?></div>
                <div class="stat-icon">
                    <i class="fas fa-dollar-sign"></i>
                </div>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-card-inner">
                <h3>Active Now</h3>
                <div class="stat-value"><?php echo e(\App\Models\User::where('last_active_at', '>=', \Carbon\Carbon::now()->subMinutes(15))->count()); ?></div>
                <div class="stat-icon">
                    <i class="fas fa-bolt"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Store and Forum Stats -->
    <div class="row mb-4">
        <!-- Store Performance -->
        <div class="col-md-6 mb-4">
            <div class="dashboard-card">
                <div class="dashboard-card-header">
                    <h3>Store Performance</h3>
                </div>
                <div class="dashboard-card-body">
                    <div class="row store-stats mb-3">
                        <div class="col-md-4">
                            <div class="small-stat">
                                <div class="small-stat-icon">
                                    <i class="fas fa-shopping-cart"></i>
                                </div>
                                <div class="small-stat-value">
                                    <?php echo e(\App\Models\Transaction::where('status', 'completed')->count()); ?>

                                </div>
                                <div class="small-stat-label">
                                    Total Sales
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="small-stat">
                                <div class="small-stat-icon">
                                    <i class="fas fa-dollar-sign"></i>
                                </div>
                                <div class="small-stat-value">
                                    <?php echo e(currency_symbol(config_value('store_currency', 'GBP'))); ?><?php echo e(number_format(\App\Models\Transaction::where('status', 'completed')->sum('amount'), 2)); ?>

                                </div>
                                <div class="small-stat-label">
                                    Total Revenue
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="small-stat">
                                <div class="small-stat-icon">
                                    <i class="fas fa-box"></i>
                                </div>
                                <div class="small-stat-value">
                                    <?php echo e(\App\Models\Package::count()); ?>

                                </div>
                                <div class="small-stat-label">
                                    Active Packages
                                </div>
                            </div>
                        </div>
                    </div>
                    <canvas id="salesChart" height="200"></canvas>
                </div>
            </div>
        </div>

        <!-- Forum Activity -->
        <div class="col-md-6 mb-4">
            <div class="dashboard-card">
                <div class="dashboard-card-header">
                    <h3>Forum Activity</h3>
                </div>
                <div class="dashboard-card-body">
                    <div class="row forum-stats mb-3">
                        <div class="col-md-4">
                            <div class="small-stat">
                                <div class="small-stat-icon">
                                    <i class="fas fa-layer-group"></i>
                                </div>
                                <div class="small-stat-value">
                                    <?php echo e(\App\Models\ForumCategory::count()); ?>

                                </div>
                                <div class="small-stat-label">
                                    Categories
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="small-stat">
                                <div class="small-stat-icon">
                                    <i class="fas fa-comments"></i>
                                </div>
                                <div class="small-stat-value">
                                    <?php echo e(\App\Models\ForumThread::count()); ?>

                                </div>
                                <div class="small-stat-label">
                                    Threads
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="small-stat">
                                <div class="small-stat-icon">
                                    <i class="fas fa-reply"></i>
                                </div>
                                <div class="small-stat-value">
                                    <?php echo e(\App\Models\ForumPost::count()); ?>

                                </div>
                                <div class="small-stat-label">
                                    Posts
                                </div>
                            </div>
                        </div>
                    </div>
                    <canvas id="forumActivityChart" height="200"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Popular Categories & Top Packages -->
    <div class="row mb-4">
        <!-- Popular Forum Categories -->
        <div class="col-md-6 mb-4">
            <div class="dashboard-card">
                <div class="dashboard-card-header">
                    <h3>Popular Forum Categories</h3>
                </div>
                <div class="dashboard-card-body">
                    <canvas id="popularCategoriesChart" height="200"></canvas>
                </div>
            </div>
        </div>

        <!-- Top Selling Packages -->
        <div class="col-md-6 mb-4">
            <div class="dashboard-card">
                <div class="dashboard-card-header">
                    <h3>Top Selling Packages</h3>
                </div>
                <div class="dashboard-card-body">
                    <canvas id="topPackagesChart" height="200"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Latest Forum Activity & Popular Boards -->
    <div class="row mb-4">
        <!-- Latest Forum Threads -->
        <div class="col-md-6 mb-4">
            <div class="dashboard-card">
                <div class="dashboard-card-header">
                    <h3>Latest Forum Threads</h3>
                </div>
                <div class="dashboard-card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Thread</th>
                                    <th>Board</th>
                                    <th>Author</th>
                                    <th>Created</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = \App\Models\ForumThread::with(['board', 'user'])->latest()->take(5)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $thread): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <a href="<?php echo e(route('forum.thread', [$thread->board->slug, $thread->slug])); ?>" class="thread-link">
                                            <?php echo e(Str::limit($thread->title, 40)); ?>

                                        </a>
                                        <div class="thread-stats">
                                            <small><?php echo e($thread->view_count); ?> views • <?php echo e($thread->postCount()); ?> replies</small>
                                        </div>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('forum.board', $thread->board->slug)); ?>" class="board-link">
                                            <?php echo e($thread->board->name); ?>

                                        </a>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <img src="<?php echo e($thread->user->avatar); ?>" alt="<?php echo e($thread->user->name); ?>" class="avatar-sm mr-2">
                                            <span><?php echo e($thread->user->name); ?></span>
                                        </div>
                                    </td>
                                    <td><?php echo e($thread->created_at->diffForHumans()); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Popular Forum Boards -->
        <div class="col-md-6 mb-4">
            <div class="dashboard-card">
                <div class="dashboard-card-header">
                    <h3>Popular Forum Boards</h3>
                </div>
                <div class="dashboard-card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Board</th>
                                    <th>Category</th>
                                    <th>Threads</th>
                                    <th>Posts</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $popularBoards = \App\Models\ForumBoard::withCount(['threads' => function($query) {
                                    $query->withCount('posts');
                                }])->orderByDesc('threads_count')->take(5)->get();
                                ?>
                                
                                <?php $__currentLoopData = $popularBoards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $board): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <a href="<?php echo e(route('forum.board', $board->slug)); ?>" class="board-link">
                                            <?php echo e($board->name); ?>

                                        </a>
                                    </td>
                                    <td>
                                        <span class="badge bg-primary"><?php echo e($board->category->name); ?></span>
                                    </td>
                                    <td><?php echo e($board->threadCount()); ?></td>
                                    <td><?php echo e($board->postCount()); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Users and Admin Actions -->
    <div class="row">
        <!-- Recent Users -->
        <div class="col-md-6 mb-4">
            <div class="dashboard-card">
                <div class="dashboard-card-header">
                    <h3>Recent Users</h3>
                </div>
                <div class="dashboard-card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Avatar</th>
                                    <th>Name</th>
                                    <th>Steam ID</th>
                                    <th>Joined</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = \App\Models\User::latest()->take(5)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <img src="<?php echo e($user->avatar); ?>" alt="<?php echo e($user->name); ?>" class="avatar-sm">
                                    </td>
                                    <td><?php echo e($user->name); ?></td>
                                    <td>
                                        <a href="<?php echo e($user->getSteamProfileUrl()); ?>" target="_blank" class="steam-link">
                                            <?php echo e($user->steamid); ?>

                                        </a>
                                    </td>
                                    <td><?php echo e($user->created_at->diffForHumans()); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Admin Actions -->
        <div class="col-md-6 mb-4">
            <div class="dashboard-card">
                <div class="dashboard-card-header">
                    <h3>Admin Actions</h3>
                </div>
                <div class="dashboard-card-body">
                    <div class="admin-action-buttons">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view users')): ?>
                        <a href="<?php echo e(route('admin.users.index')); ?>" class="admin-action-btn">
                            <i class="fas fa-users"></i>
                            <span>Manage Users</span>
                        </a>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view roles')): ?>
                        <a href="<?php echo e(route('admin.roles')); ?>" class="admin-action-btn">
                            <i class="fas fa-user-tag"></i>
                            <span>Manage Roles</span>
                        </a>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view configurations')): ?>
                        <a href="<?php echo e(route('admin.configurations.index')); ?>" class="admin-action-btn">
                            <i class="fas fa-cogs"></i>
                            <span>System Settings</span>
                        </a>
                        <?php endif; ?>
                        
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view forum categories')): ?>
                        <a href="<?php echo e(route('admin.forum.categories')); ?>" class="admin-action-btn">
                            <i class="fas fa-folder-tree"></i>
                            <span>Forum Categories</span>
                        </a>
                        <?php endif; ?>
                        
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view packages')): ?>
                        <a href="<?php echo e(route('admin.packages.index')); ?>" class="admin-action-btn">
                            <i class="fas fa-box"></i>
                            <span>Packages</span>
                        </a>
                        <?php endif; ?>
                        
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view transactions')): ?>
                        <a href="<?php echo e(route('admin.transactions.index')); ?>" class="admin-action-btn">
                            <i class="fas fa-credit-card"></i>
                            <span>Transactions</span>
                        </a>
                        <?php endif; ?>
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.9.4/Chart.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Sales Chart - Last 7 days
    const salesCtx = document.getElementById('salesChart').getContext('2d');
    new Chart(salesCtx, {
        type: 'bar',
        data: {
            labels: <?php echo json_encode(collect(range(6, 0))->map(function($day) { return \Carbon\Carbon::now()->subDays($day)->format('D'); })); ?>,
            datasets: [{
                label: 'Revenue (<?php echo e(currency_symbol(config_value('store_currency', 'GBP'))); ?>)',
                data: <?php echo json_encode(collect(range(6, 0))->map(function($day) { 
                    $date = \Carbon\Carbon::now()->subDays($day);
                    return \App\Models\Transaction::where('status', 'completed')
                        ->whereDate('created_at', $date->format('Y-m-d'))
                        ->sum('amount');
                })); ?>,
                backgroundColor: 'rgba(28, 200, 138, 0.7)',
                borderColor: 'rgba(28, 200, 138, 1)',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                xAxes: [{
                    gridLines: {
                        display: false,
                        drawBorder: false
                    }
                }],
                yAxes: [{
                    ticks: {
                        callback: function(value) {
                            return '<?php echo e(currency_symbol(config_value('store_currency', 'GBP'))); ?>' + value;
                        }
                    }
                }]
            },
            tooltips: {
                callbacks: {
                    label: function(tooltipItem, data) {
                        return '<?php echo e(currency_symbol(config_value('store_currency', 'GBP'))); ?>' + tooltipItem.yLabel.toFixed(2);
                    }
                }
            }
        }
    });

    // Forum Activity - Last 7 days
    const forumActivityCtx = document.getElementById('forumActivityChart').getContext('2d');
    new Chart(forumActivityCtx, {
        type: 'line',
        data: {
            labels: <?php echo json_encode(collect(range(6, 0))->map(function($day) { return \Carbon\Carbon::now()->subDays($day)->format('D'); })); ?>,
            datasets: [{
                label: 'New Threads',
                data: <?php echo json_encode(collect(range(6, 0))->map(function($day) { 
                    $date = \Carbon\Carbon::now()->subDays($day);
                    return \App\Models\ForumThread::whereDate('created_at', $date->format('Y-m-d'))->count();
                })); ?>,
                backgroundColor: 'rgba(54, 162, 235, 0)',
                borderColor: 'rgba(54, 162, 235, 1)',
                pointBackgroundColor: 'rgba(54, 162, 235, 1)',
                pointBorderColor: '#fff',
                borderWidth: 2,
                pointRadius: 3
            }, {
                label: 'New Posts',
                data: <?php echo json_encode(collect(range(6, 0))->map(function($day) { 
                    $date = \Carbon\Carbon::now()->subDays($day);
                    return \App\Models\ForumPost::whereDate('created_at', $date->format('Y-m-d'))->count();
                })); ?>,
                backgroundColor: 'rgba(255, 99, 132, 0)',
                borderColor: 'rgba(255, 99, 132, 1)',
                pointBackgroundColor: 'rgba(255, 99, 132, 1)',
                pointBorderColor: '#fff',
                borderWidth: 2,
                pointRadius: 3
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                xAxes: [{
                    gridLines: {
                        display: false,
                        drawBorder: false
                    }
                }],
                yAxes: [{
                    ticks: {
                        beginAtZero: true,
                        precision: 0
                    }
                }]
            }
        }
    });

    // Popular Categories Chart
    const popularCategoriesCtx = document.getElementById('popularCategoriesChart').getContext('2d');
    
    // Get categories data
    const categoryData = {
        <?php
        // Get categories with board counts and thread counts
        $categories = \App\Models\ForumCategory::with('boards')
            ->get()
            ->map(function($category) {
                // For each category, count the total threads across all boards
                $threadCount = $category->boards->sum(function($board) {
                    return $board->threadCount();
                });
                
                // Return the category name and thread count
                return [
                    'name' => $category->name,
                    'count' => $threadCount
                ];
            })
            ->sortByDesc('count')
            ->take(5);
        ?>
        
        // Output the categories as a JavaScript-friendly object
        labels: <?php echo json_encode($categories->pluck('name')); ?>,
        data: <?php echo json_encode($categories->pluck('count')); ?>

    };
    
    new Chart(popularCategoriesCtx, {
        type: 'doughnut',
        data: {
            labels: categoryData.labels,
            datasets: [{
                data: categoryData.data,
                backgroundColor: [
                    'rgba(78, 115, 223, 0.7)',
                    'rgba(28, 200, 138, 0.7)',
                    'rgba(246, 194, 62, 0.7)',
                    'rgba(231, 74, 59, 0.7)',
                    'rgba(84, 84, 84, 0.7)'
                ],
                hoverBackgroundColor: [
                    'rgba(78, 115, 223, 1)',
                    'rgba(28, 200, 138, 1)',
                    'rgba(246, 194, 62, 1)',
                    'rgba(231, 74, 59, 1)',
                    'rgba(84, 84, 84, 1)'
                ],
                hoverBorderColor: "rgba(234, 236, 244, 1)",
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            tooltips: {
                backgroundColor: "rgb(255,255,255)",
                bodyFontColor: "#858796",
                borderColor: '#dddfeb',
                borderWidth: 1,
                xPadding: 15,
                yPadding: 15,
                displayColors: false,
                caretPadding: 10,
            },
            legend: {
                display: true,
                position: 'bottom'
            },
            cutoutPercentage: 70
        }
    });

    // Top Packages Chart
    const topPackagesCtx = document.getElementById('topPackagesChart').getContext('2d');
    new Chart(topPackagesCtx, {
        type: 'horizontalBar',
        data: {
            labels: <?php echo json_encode(\App\Models\Package::withCount(['transactions' => function($query) { $query->where('status', 'completed'); }])->having('transactions_count', '>', 0)->orderByDesc('transactions_count')->take(5)->pluck('name')); ?>,
            datasets: [{
                label: 'Sales',
                data: <?php echo json_encode(\App\Models\Package::withCount(['transactions' => function($query) { $query->where('status', 'completed'); }])->having('transactions_count', '>', 0)->orderByDesc('transactions_count')->take(5)->pluck('transactions_count')); ?>,
                backgroundColor: [
                    'rgba(78, 115, 223, 0.7)',
                    'rgba(28, 200, 138, 0.7)',
                    'rgba(246, 194, 62, 0.7)',
                    'rgba(231, 74, 59, 0.7)',
                    'rgba(84, 84, 84, 0.7)'
                ],
                borderColor: [
                    'rgba(78, 115, 223, 1)',
                    'rgba(28, 200, 138, 1)',
                    'rgba(246, 194, 62, 1)',
                    'rgba(231, 74, 59, 1)',
                    'rgba(84, 84, 84, 1)'
                ],
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                xAxes: [{
                    ticks: {
                        beginAtZero: true,
                        precision: 0
                    }
                }]
            },
            legend: {
                display: false
            }
        }
    });

    // Server Status Refresh Button
    document.querySelector('.refresh-server-status').addEventListener('click', function() {
        this.innerHTML = '<i class="fas fa-sync-alt fa-spin"></i> Refreshing...';
        
        // Simulate server status refresh
        setTimeout(() => {
            this.innerHTML = '<i class="fas fa-sync-alt"></i> Refresh';
            
            // You could add an AJAX call here to get real server data
            // Example:
            // fetch('/admin/server/status')
            //     .then(response => response.json())
            //     .then(data => {
            //         // Update server status UI with the new data
            //     })
            //     .catch(error => {
            //         console.error('Error fetching server status:', error);
            //     })
            //     .finally(() => {
            //         this.innerHTML = '<i class="fas fa-sync-alt"></i> Refresh';
            //     });
        }, 1500);
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>